#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Zen TimeMod01.fsh   by   zxxuan1001
//https://www.shadertoy.com/view/Wlj3zV
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float TURBULENCE = 0.04;
//noise function from iq: https://www.shadertoy.com/view/Msf3WH
vec2 hash( vec2 p ) 
{
	p = vec2( dot(p,vec2(127.1,311.7)), dot(p,vec2(269.5,183.3)) );
	return -1.0 + 2.0*fract(sin(p)*43758.5453123);
}

float noise( in vec2 p )
{
    const float K1 = 0.366025404; // (sqrt(3)-1)/2;
    const float K2 = 0.211324865; // (3-sqrt(3))/6;

	vec2  i = floor( p + (p.x+p.y)*K1 );
    vec2  a = p - i + (i.x+i.y)*K2;
    float m = step(a.y,a.x); 
    vec2  o = vec2(m,1.0-m);
    vec2  b = a - o + K2;
	vec2  c = a - 1.0 + 2.0*K2;
    vec3  h = max( 0.5-vec3(dot(a,a), dot(b,b), dot(c,c) ), 0.0 );
	vec3  n = h*h*h*h*vec3( dot(a,hash(i+0.0)), dot(b,hash(i+o)), dot(c,hash(i+1.0)));
    return dot( n, vec3(70.0) );
}

const mat2 m2 = mat2(1.6,  1.2, -1.2,  1.6);

float fbm(vec2 p) {
    float amp = 0.5;
    float h = 0.0;
    for (int i = 0; i < 8; i++) {
        float n = noise(p);
        h += amp * n;
        amp *= 0.5;
        p = m2 * p ;
    }
    
	return  0.5 + 0.5*h;
}
vec3 smokeEffect(vec2 uv) {
    vec3 col = vec3(0.0);
    // time scale
    float v = 0.0002;
    vec3 smoke = vec3(1.0);
    //uv += mo * 10.0; 
   
    vec2 scale = uv * 0.5 ;
    vec2 turbulence = TURBULENCE * vec2(noise(vec2(uv.x * 3.5, uv.y * 3.2)), noise(vec2(uv.x * 2.2, uv.y * 1.5)));
    scale += turbulence;
	float n1 = fbm(vec2(scale.x - abs(sin(iTime * v * 2.0)), scale.y - 50.0 * abs(sin(iTime * v))));
    col =  mix( col, smoke, smoothstep(0.5, 0.9, n1));
    //float y = fragCoord.y/iResolution.y;
    //float fade = exp(-(y*y));
    //col *= fade;
    col = clamp(col, vec3(0.0), vec3(1.0));
    return col;
}

float circle(vec2 p, float r) {
    float c = length(p) - r;
    return smoothstep(r + 0.01, r, c);
}

float sinwave(vec2 p, float scale, float amp) {
    float wave = cos(p.x * scale + 0.5) + 0.25 * cos(p.x * scale * scale);
    float s = smoothstep(amp + 0.01, amp, amp * wave - p.y);
    return s;
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = fragCoord/iResolution.xy;
    vec2 p = fragCoord/iResolution.xy;
    p -= 0.5;
    p.x *= iResolution.x / iResolution.y;
    
    vec3 col = vec3(0.0);    
    vec3 smoke = smokeEffect(p);
    
    vec3 tex = 0.02 * texture2D(texture0, uv * 2.5).rgb;   
    vec3 background = 0.7 * vec3(238.0,232.0,170.0)/255.0 + tex;
    vec3 mountCol = mix(vec3(102.0,153.0,153.0)/255.0, vec3(153.0,204.0,0.0)/255.0, p.y + 0.5);
    vec3 sunCol = 0.85 * mix(vec3(1.0, 0.0, 0.0), vec3(1.0, 1.0, 0.0), p.y + 0.5);
    vec3 cloudCol = vec3(0.9);
    float t = iTime * 0.05;
    vec2 sunPos = p - vec2(0.4 * cos(t), 0.4 * sin(t));
    float sun = circle(sunPos, 0.1); 
    float mountain1 = sinwave(p - vec2(0.5, -0.1), 3.0, 0.1);
    float mountain2 = sinwave(p, 3.0, 0.2);
    float cloud = 1.0 - smoke.r;
    col = mix(background, sunCol, sun);
    col = mix(mountCol * 0.9, col, mountain1);
    col = mix(cloudCol, col, cloud);
    col = mix(mountCol, col, mountain2);
     
    col *= 0.2 + 0.8 * pow(32.0 * uv.x * uv.y * (1.0 - uv.x) * (1.0 - uv.y), 0.2);
    fragColor = vec4(col ,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

